using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Windows.Forms;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmOrderHistoryReport
	/// </summary>
	public class FrmOrderHistoryReport : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.OrderReport _orderReport;

		private System.Windows.Forms.Button btnClose;
		private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
        private System.Windows.Forms.Panel pnlReport;
		private System.Windows.Forms.PrintDialog printDialog1;
        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvOrderHistory;
		private System.ComponentModel.IContainer components = null;
        private DataSet _dsReportData = new DataSet();

		#region constructors

		/// <summary>
		/// BR_86.04, BR_86.06 (BRs that define how the report is formatted)
		/// </summary>
		/// <param name="orderReport"></param>
		public FrmOrderHistoryReport(BOL.OrderReport orderReport)
		{
			InitializeComponent();
			SetComponentProperties();
			_orderReport = orderReport;

			using (new WaitCursor())
			{
				_dsReportData = _orderReport.CreateReport();
			
				if (_orderReport.IsSingleOrderReport)
				{
					DisplaySingleOrderReport();
				}
				else
				{
					DisplayMultiOrderReport();
				}
			}
		}

		#endregion


		#region methods

		/// <summary>
		/// The dataset contains 3 tables:
		/// Table 1 contains the high level information related to the order
		/// Table 2 contains historical specimen information (SpecimenHistory table)
		/// Table 3 contains reflex tests associated with the order
		/// </summary>
		private void DisplaySingleOrderReport()
		{
#if DEBUG
            //_dsReportData.Tables["Order"].WriteXml("e:\\temp\\SingleOrderDataSet.xml", XmlWriteMode.WriteSchema);
            //_dsReportData.Tables["SpecimenHistory"].WriteXml("e:\\temp\\SpecimenDataSet.xml", XmlWriteMode.WriteSchema);
            //_dsReportData.Tables["ReflexTests"].WriteXml("e:\\temp\\ReflexTestsDataSet.xml", XmlWriteMode.WriteSchema);
#endif
            this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC086.FrmOrderHistoryReport_Single());
            //
            if (_dsReportData == null || _dsReportData.Tables.Count == 0)
            {
                throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidFormat("Report DataSet").ResString);
            }
            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(ThisUser.UserName);

            ReportDataSource reportSourceMain = new ReportDataSource();
            if (_dsReportData.Tables.Count > 0)
            {
                reportSourceMain.Name = "SingleOrderDataSet";
                reportSourceMain.Value = _dsReportData.Tables["Order"];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }
            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.OrderHistory.SingleOrderHistoryReport.rdlc");
            Stream streamSpecimen = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.OrderHistory.SpecimenHistory.rdlc");
            Stream streamReflexTests = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.OrderHistory.ReflexTests.rdlc");

            this.rvOrderHistory.LocalReport.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);

            this.rvOrderHistory.LocalReport.DataSources.Add(reportSourceHeader);
            this.rvOrderHistory.LocalReport.DataSources.Add(reportSourceMain);
            this.rvOrderHistory.LocalReport.LoadReportDefinition(stream);
            this.rvOrderHistory.LocalReport.LoadSubreportDefinition("SpecimenHistory", streamSpecimen);
            this.rvOrderHistory.LocalReport.LoadSubreportDefinition("ReflexTests", streamReflexTests);

            this.rvOrderHistory.RefreshReport();
		}

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "SpecimenHistory" || e.DataSourceNames[0].ToString() == "SpecimenDataSet")
            {
                ReportDataSource reportSpecimen = new ReportDataSource();
                if (_dsReportData.Tables.IndexOf("SpecimenHistory") != -1)
                {
                    reportSpecimen.Name = "SpecimenDataSet";
                    reportSpecimen.Value = _dsReportData.Tables["SpecimenHistory"];
                }
                e.DataSources.Add(reportSpecimen);
            }
            else if (e.ReportPath == "ReflexTests" || e.DataSourceNames[0].ToString() == "ReflexTestsDataSet")
            {
                ReportDataSource reportReflexTests = new ReportDataSource();
                if (_dsReportData.Tables.IndexOf("ReflexTests") != -1)
                {
                    reportReflexTests.Name = "ReflexTestsDataSet";
                    reportReflexTests.Value = _dsReportData.Tables["ReflexTests"];
                }
                e.DataSources.Add(reportReflexTests);
            }
        }

		/// <summary>
		/// DisplayMultiOrderReport
		/// </summary>
		private void DisplayMultiOrderReport()
		{
#if DEBUG
			//reportData.Tables[0].WriteXml("e:\\temp\\MultiOrderDataSet.xml", XmlWriteMode.WriteSchema);
#endif
            this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC086.FrmOrderHistoryReport());
			//
            if (_dsReportData == null || _dsReportData.Tables.Count == 0)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidFormat("Report DataSet").ResString);
			}
            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(ThisUser.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(_orderReport.SearchCriteria);

            ReportDataSource reportSourceMain = new ReportDataSource();
            if (_dsReportData.Tables.Count > 0)
            {
                reportSourceMain.Name = "MultiOrderDataSet";
                reportSourceMain.Value = _dsReportData.Tables[0];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream;

            if (_orderReport.SortByTreatingSpecialty)
			{
                stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.OrderHistory.MultiOrderTreatingSpecialty.rdlc");
            }
			else
			{
                stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.OrderHistory.MultiOrderOrderingLocation.rdlc");
            }

            this.rvOrderHistory.LocalReport.DataSources.Add(reportSourceHeader);
            this.rvOrderHistory.LocalReport.DataSources.Add(reportSourceFooter);
            this.rvOrderHistory.LocalReport.DataSources.Add(reportSourceMain);
            this.rvOrderHistory.LocalReport.LoadReportDefinition(stream);
            this.rvOrderHistory.RefreshReport();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmOrderHistoryReport));
            this.btnClose = new System.Windows.Forms.Button();
            this.btnPrint = new System.Windows.Forms.Button();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.picImage = new System.Windows.Forms.PictureBox();
            this.pnlReport = new System.Windows.Forms.Panel();
            this.rvOrderHistory = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).BeginInit();
            this.pnlReport.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.TabIndex = 1;
            this.vbecsLogo1.Title = "Order History Report";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.TabIndex = 0;
            // 
            // btnClose
            // 
            this.btnClose.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnClose.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnClose.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnClose.Location = new System.Drawing.Point(564, 416);
            this.btnClose.Name = "btnClose";
            this.btnClose.Size = new System.Drawing.Size(75, 23);
            this.btnClose.TabIndex = 2;
            this.btnClose.Text = "&Close";
            this.btnClose.Click += new System.EventHandler(this.btnClose_Click);
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(484, 416);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(75, 23);
            this.btnPrint.TabIndex = 1;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.picImage);
            this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grpImage.Location = new System.Drawing.Point(4, 0);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 412);
            this.grpImage.TabIndex = 3;
            this.grpImage.TabStop = false;
            // 
            // picImage
            // 
            this.picImage.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
            this.picImage.Location = new System.Drawing.Point(4, 12);
            this.picImage.Name = "picImage";
            this.picImage.Size = new System.Drawing.Size(45, 45);
            this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picImage.TabIndex = 0;
            this.picImage.TabStop = false;
            // 
            // pnlReport
            // 
            this.pnlReport.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlReport.Controls.Add(this.rvOrderHistory);
            this.pnlReport.Controls.Add(this.btnPrint);
            this.pnlReport.Controls.Add(this.btnClose);
            this.pnlReport.Controls.Add(this.grpImage);
            this.pnlReport.Location = new System.Drawing.Point(0, 32);
            this.pnlReport.Name = "pnlReport";
            this.pnlReport.Size = new System.Drawing.Size(640, 440);
            this.pnlReport.TabIndex = 2;
            // 
            // rvOrderHistory
            // 
            this.rvOrderHistory.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvOrderHistory.Location = new System.Drawing.Point(60, 5);
            this.rvOrderHistory.Name = "rvOrderHistory";
            this.rvOrderHistory.Size = new System.Drawing.Size(577, 405);
            this.rvOrderHistory.TabIndex = 4;
            // 
            // printDialog1
            // 
            this.printDialog1.AllowPrintToFile = false;
            // 
            // FrmOrderHistoryReport
            // 
            this.AcceptButton = this.btnPrint;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnClose;
            this.ClientSize = new System.Drawing.Size(642, 473);
            this.Controls.Add(this.pnlReport);
            this.hlphelpChm.SetHelpKeyword(this, "Order_History_Report.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(600, 450);
            this.Name = "FrmOrderHistoryReport";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Order History Report";
            this.Load += new System.EventHandler(this.FrmOrderHistoryReport_Load);
            this.Controls.SetChildIndex(this.pnlReport, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).EndInit();
            this.pnlReport.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
            BOL.VbecsReport.SetUpReportButtons(this.rvOrderHistory);
        }

		#endregion


		#region events

		private void btnPrint_Click(object sender, System.EventArgs e)
		{
            //CR 3449
            try
            {
                this.rvOrderHistory.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }

		private void btnClose_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		#endregion

        private void FrmOrderHistoryReport_Load(object sender, EventArgs e)
        {

            this.rvOrderHistory.RefreshReport();
        }

	}
}

